program ADAPTIVEQUAD;
{--------------------------------------------------------------------}
{  Alg7'5.pas   Pascal program for implementing Algorithm 7.5        }
{                                                                    }
{  NUMERICAL METHODS: Pascal Programs, (c) John H. Mathews 1995      }
{  To accompany the text:                                            }
{  NUMERICAL METHODS for Math., Science & Engineering, 2nd Ed, 1992  }
{  Prentice Hall, Englewood Cliffs, New Jersey, 07632, U.S.A.        }
{  Prentice Hall, Inc.; USA, Canada, Mexico ISBN 0-13-624990-6       }
{  Prentice Hall, International Editions:   ISBN 0-13-625047-5       }
{  This free software is compliments of the author.                  }
{  E-mail address:       in%"mathews@fullerton.edu"                  }
{                                                                    }
{  Algorithm 7.5 (Adaptive Quadrature Using Simpson's Rule).         }
{  Section   7.4, Adaptive Quadrature, Page 389                      }
{--------------------------------------------------------------------}

  uses
    crt;

  const
    FunMax = 9;

  type
    LETTER = string[8];
    LETTERS = string[200];
    States = (Changes, Done, Working);
    DoSome = (Go, Stop);
    BIGVEC = array[0..201] of real;
    LITTLEVECTOR = array[1..11] of real;
    MATRIX = array[0..201, 1..11] of real;

  var
    FunType, Inum, M, Meth, Mold, Sub: integer;
    A, B, ErrBdd, Integral, Rnum, S2, T2, Tolerance: real;
    VF, VX: BIGVEC;
    SRmat: MATRIX;   {place dimension statement in outer program to pass all the work . }
    Ans: CHAR;
    State: States;
    DoMo: DoSome;
    Mess: LETTERS;

  function F (var X: real): real;
  begin
    case FunType of
      0: 
        begin
          if X <> 0 then
            F := SIN(X) / X
          else
            F := 1;
        end;
      1: 
        begin
          if X <> 0 then
            F := 1 / X
          else
            begin
              if A = 0 then
                F := 1E37;
              if B = 0 then
                F := -1E37;
              if A * B < 0 then
                F := 0;
            end;
        end;
      2: 
        F := 4 / (1 + X * X);
      3: 
        F := 13 * (X - X * X) * EXP(-3 * X / 2);
      4: 
        F := SIN(2 * X) / (1 + X * X * X * X * X);
      5: 
        F := SIN(4 * X) * EXP(-2 * X);
      6: 
        begin
          if X > 0 then
            F := 1 / SQRT(X)
          else
            F := 0;
        end;
      7: 
        F := 1 / (X * X + 1 / 10);
      8: 
        begin
          if X <> 0 then
            F := SIN(1 / X)
          else
            F := 0;
        end;
      9: 
        begin
          if (0 <= X) and (X <= 4) then
            F := SQRT(4 * X - X * X)
          else
            F := 0;
        end;

    end;
  end;

  procedure PRINTFUNCTION (FunType: integer);
  begin
    case FunType of
      0: 
        WRITE('SIN(X)/X');
      1: 
        WRITE('1/X');
      2: 
        WRITE('4 / (1 + X * X)');
      3: 
        WRITE('13 * (X - X * X) * EXP(-3 * X / 2)');
      4: 
        WRITE('SIN(2 * X) / (1 + X * X * X * X * X)');
      5: 
        WRITE('SIN(4 * X) * EXP(-2 * X)');
      6: 
        WRITE('1 / SQRT(X)');
      7: 
        WRITE('1 / (X * X + 1 / 10)');
      8:
        WRITE('SIN(1 / X)');
      9: 
        WRITE('SQRT(4 * X - X * X)');
    end;
  end;

  procedure AdaptQuad ({FUNCTION F(VAR X:real): real;}
                  A, B, Tol: real; var Integral, ErrBdd: real; var M: integer);
    type
      StatesQuad = (Done, Iterating);
    var
      J, K, N: integer;
      Sum1, Sum2: real;
      State: StatesQuad;
      SRvec: LITTLEVECTOR;
        {SRmat: MATRIX;  place dimension statement outside procedure to pass all the work.}

    procedure Srule ({FUNCTION F(VAR X:real): real;}
                    A, B, Tol0: real; var SRvec: LITTLEVECTOR);
      var
        C, Check, Fa, Fb, Fc, Err, H, S, S2, Tol1: real;
    begin
      H := (B - A) / 2;
      C := (A + B) / 2;
      Fa := F(A);
      Fc := F(C);
      Fb := F(B);
      S := H * (F(A) + 4 * F(C) + F(B)) / 3;
      S2 := S;
      Tol1 := Tol0;
      Err := Tol0;
      Check := 0;
      SRvec[1] := A;
      SRvec[2] := C;
      SRvec[3] := B;
      SRvec[4] := Fa;
      SRvec[5] := Fc;
      SRvec[6] := Fb;
      SRvec[7] := S;
      SRvec[8] := S2;
      SRvec[9] := Err;
      SRvec[10] := Tol1;
      SRvec[11] := Check;
    end;

    procedure Refine (P: integer; var SRmat: MATRIX);
      label
        999;
      var
        J, K: integer;
        C, Check, Err, Fa, Fb, Fc, H, S, S2, Tol2: real;
        SR0vec, SR1vec, SR2vec: LITTLEVECTOR;
    begin
      State := Done;
      for K := 1 to 11 do
        Sr0vec[K] := SRmat[P, K];
      A := SR0vec[1];
      C := SR0vec[2];
      B := SR0vec[3];
      Fa := SR0vec[4];
      Fc := SR0vec[5];
      Fb := SR0vec[6];
      S := SR0vec[7];
      S2 := SR0vec[8];
      Err := SR0vec[9];
      Tol := SR0vec[10];
      Check := SR0vec[11];
      if Check = 1 then
        goto 999;
      Tol2 := Tol / 2;
      Srule(A, C, Tol2, SR1vec);
      Srule(C, B, Tol2, SR2vec);
      Err := ABS(SR0vec[7] - SR1vec[7] - SR2vec[7]) / 10;
      if Err < Tol then
        SR0vec[11] := 1;
      if Err < Tol then
        begin
          for K := 1 to 11 do
            SRmat[P, K] := Sr0vec[K];
          SRmat[P, 8] := SR1vec[7] + SR2vec[7];
          SRmat[P, 9] := Err;
        end
      else
        begin
          for J := M + 1 downto P do
            for K := 1 to 11 do
              SRmat[J, K] := SRmat[J - 1, K];
          M := M + 1;
          for K := 1 to 11 do
            SRmat[P, K] := Sr1vec[K];
          for K := 1 to 11 do
            SRmat[P + 1, K] := Sr2vec[K];
          State := Iterating;
        end;
999:
    end;

  begin  {Start of program AdaptQuad }
    Srule(A, B, Tol, SRvec);
    for K := 1 to 11 do
      SRmat[1, K] := Srvec[K];
    M := 1;
    State := Iterating;
    while State = Iterating do
      begin
        N := M;
        for J := N downto 1 do
          Refine(J, SRmat);
      end;
    Sum1 := 0;
    Sum2 := 0;
    for J := 1 to M do
      begin
        Sum1 := Sum1 + SRmat[J, 8];
        Sum2 := Sum2 + Abs(SRmat[J, 9]);
      end;
    Integral := Sum1;
    ErrBdd := Sum2;
  end;

  procedure MESSAGE (var Meth: integer);
    var
      K: integer;
      Resp: CHAR;
  begin
    CLRSCR;
    WRITELN('                    NUMERICAL INTEGRATION');
    WRITELN;
  end;

  procedure INPUT (var FunType: integer);
    var
      K: integer;
  begin
    CLRSCR;
    WRITELN('         Adaptive quadrature is performed to compute ');
    WRITELN;
    WRITELN('     an approximate value of the definite integral:');
    WRITELN;
    WRITELN('                           B');
    WRITELN('                           /');
    WRITELN('                           | f(x) dx');
    WRITELN('                           /');
    WRITELN('                           A');
    WRITELN;
    WRITELN('     Choose your function:');
    WRITELN;
    for K := 0 to 9 do
      begin
        WRITE('     <', K : 2, ' >   F(X) = ');
        PRINTFUNCTION(K);
        WRITELN;
      end;
    Mess := '             SELECT < 0 - 9 > ?  ';
    FunType := 0;
    WRITE(Mess);
    READLN(FunType);
    if FunType < 0 then
      FunType := 0;
    if FunType > FunMax then
      FunType := FunMax;
  end;

  procedure PROBLEM (FunType: integer);
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN('     You chose to approximate the definite integral:');
    WRITELN;
    WRITELN('                B');
    WRITELN('                /');
    WRITE('                | ');
    PRINTFUNCTION(FunType);
    WRITELN(' DX');
    WRITELN('                /');
    WRITELN('                A');
  end;

  procedure EPOINTS (var A, B, Tol: real; var State: STATES);
    type
      STATUS = (Change, Enter, Done);
      LETTER = string[1];
    var
      Valu: real;
      Resp: CHAR;
      Stat: STATUS;
  begin
    Stat := Enter;
    if State = Changes then
      Stat := Change;
    while (Stat = Enter) or (Stat = Change) do
      begin
        PROBLEM(FunType);
        if (Stat = Enter) then
          begin
            Mess := '               ENTER the left  endpoint    A = ';
            A := 1;
            WRITE(Mess);
            READLN(A);
            Mess := '               ENTER the right endpoint    B = ';
            B := 2;
            WRITE(Mess);
            READLN(B);
            Mess := '               ENTER  the  tolerance     Tol = ';
            WRITE(Mess);
            READLN(Tol);
            if Tol < 0 then
              Tol := 0.000000001;
            if Tol > 0.5 then
              Tol := 0.5;
          end
        else
          begin
            WRITELN('                  The left  endpoint is    A = ', A : 15 : 7);
            WRITELN;
            WRITELN('                  The right endpoint is    B = ', B : 15 : 7);
            WRITELN;
            WRITE('     ');
            WRITELN('             The tolerance used is  Tol = ', Tol : 15 : 7);
          end;
        WRITELN;
        WRITE('        Do you want to make a change ?  <Y/N>  ');
        READ(Resp);
        WRITELN;
        if (Resp = 'Y') or (Resp = 'y') then
          begin
            Stat := Change;
            PROBLEM(FunType);
            WRITELN('     The current left  endpoint is    A = ', A : 15 : 7);
            Mess := '     ENTER  the NEW left  endpoint    A = ';
            WRITE(Mess);
            READLN(A);
            WRITELN('     The current right endpoint is    B = ', B : 15 : 7);
            Mess := '     ENTER  the NEW right endpoint    B = ';
            WRITE(Mess);
            READLN(B);
            WRITELN('     The  current tolerance  is     Tol = ', Tol : 15 : 7);
            Mess := '     ENTER  the  NEW  value of      Tol = ';
            WRITE(Mess);
            READLN(Tol);
            if Tol < 0 then
              Tol := 0.000000001;
            if Tol > 0.5 then
              Tol := 0.5;
          end
        else
          Stat := Done;
      end;
  end;

  procedure RESULTS (A, B, Tolerance, Integral, ErrBdd: real; M: integer);
    var
      Sum: real;
  begin
    CLRSCR;
    WRITELN;
    WRITELN;
    WRITELN(B : 13 : 5);
    WRITELN('       /');
    WRITE('       |  ');
    PRINTFUNCTION(FunType);
    WRITELN(' DX ~', Integral : 15 : 8);
    WRITELN('       /');
    WRITELN(A : 13 : 5);
    WRITELN;
    WRITELN('     Adaptive quadrature was used to approximate');
    WRITELN;
    WRITELN('the value of the definite integral:');
    WRITELN;
    WRITE('     F(X) = ');
    PRINTFUNCTION(FunType);
    WRITELN;
    WRITELN;
    WRITELN('Taken over the interval   [', A : 15 : 8, '  ,', B : 15 : 8, '  ].');
    WRITELN;
    if M = 1 then
      WRITELN('There was 1 subinterval used in the approximation.')
    else
      WRITELN('There were ', M : 1, ' subinterval used in the approximation.');
    WRITELN;
    WRITELN('Adaptive quadrature found the approximation  ', Integral : 15 : 8);
    WRITELN;
    WRITELN('The error bound for this approximation is    ', ErrBdd : 15 : 8);
    WRITELN;
    if ErrBdd < Tolerance then
      WRITELN('The error bound is less than the tolerance   ', Tolerance : 15 : 8);
  end;

  procedure PRINTAPPROX;
    var
      J: integer;
  begin
    CLRSCR;
    WRITELN;
    WRITELN('        a              b        S(a,c)+S(c,b)    Error Bound      Tolerance');
    WRITELN;
    for J := 1 to M do
      begin
        WRITE(SRmat[J, 1] : 15 : 7, SRmat[J, 3] : 15 : 7, SRmat[J, 8] : 15 : 7);
        WRITELN(SRmat[J, 9] : 15 : 7, SRmat[J, 10] : 15 : 7);
      end;
    WRITELN;
    WRITE('                  Press the <ENTER> key.  ');
    READLN(Ans);
    WRITELN;
  end;

begin                                            {Begin Main Program}
  Meth := 2;
  while Meth <> 0 do
    begin
      MESSAGE(Meth);
      DoMo := Go;
      while DoMo = Go do
        begin
          INPUT(FunType);
          State := Working;
          while (State = Working) or (State = Changes) do
            begin
              EPOINTS(A, B, Tolerance, State);
              AdaptQuad(A, B, Tolerance, Integral, ErrBdd, M);
              RESULTS(A, B, Tolerance, Integral, ErrBdd, M);
              WRITELN;
              WRITE('Want to see the subintervals and summation terms ?  <Y/N>  ');
              READLN(Ans);
              Ans := 'y';
              WRITELN;
              if (Ans = 'Y') or (Ans = 'y') then
                PRINTAPPROX;
              WRITELN;
              WRITE('Want  to  try   another  interval ?  <Y/N>  ');
              READLN(Ans);
              WRITELN;
              if (Ans <> 'Y') and (Ans <> 'y') then
                State := Done;
            end;
          WRITELN;
          WRITE('Want to use a  different function ?  <Y/N>  ');
          READLN(Ans);
          WRITELN;
          if (Ans <> 'Y') and (Ans <> 'y') then
            DoMo := Stop;
        end;
      WRITELN;
      WRITE('Do you want to try another method ?  <Y/N>  ');
      READLN(Ans);
      WRITELN;
      if (Ans <> 'Y') and (Ans <> 'y') then
        Meth := 0;
    end;                                          {End of Main Program}
end.

